/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.utility;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class Color {
    @Nonnull
    public static final Color INVALID_COLOR = new Color(-1.0f, -1.0f, -1.0f, -1.0f);
    @Nonnull
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    @Nonnull
    private static final String COLOR_TAG = "color";
    public final float a;
    public final float b;
    public final float g;
    public final float r;

    public Color(float red, float green, float blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
    }

    public Color(int color) {
        this(color, true);
    }

    public Color(int color, boolean ignoreAlpha) {
        this.a = ignoreAlpha ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        this.r = (float)(color >> 16 & 0xFF) / 255.0f;
        this.g = (float)(color >> 8 & 0xFF) / 255.0f;
        this.b = (float)(color & 0xFF) / 255.0f;
    }

    public Color(@Nonnull String hex) {
        this(Integer.parseInt(hex, 16));
    }

    @Nonnull
    public static Color average(@Nonnull Color colorA, @Nonnull Color colorB, float percentage) {
        float opposite = 1.0f - percentage;
        float averageR = (float)Math.sqrt(colorA.r * colorA.r * opposite + colorB.r * colorB.r * percentage);
        float averageG = (float)Math.sqrt(colorA.g * colorA.g * opposite + colorB.r * colorB.g * percentage);
        float averageB = (float)Math.sqrt(colorA.b * colorA.b * opposite + colorB.r * colorB.b * percentage);
        float averageA = colorA.a * opposite + colorB.a * percentage;
        return new Color(averageR, averageG, averageB, averageA);
    }

    @Nonnull
    public static Color fromNBT(@Nonnull CompoundTag compoundNBT) {
        if (compoundNBT.m_128441_(COLOR_TAG)) {
            CompoundTag colorTag = compoundNBT.m_128469_(COLOR_TAG);
            float a = colorTag.m_128457_("colorA");
            float r = colorTag.m_128457_("colorR");
            float b = colorTag.m_128457_("colorB");
            float g = colorTag.m_128457_("colorG");
            return new Color(a, r, b, g);
        }
        return INVALID_COLOR;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Float.compare(color.r, this.r) == 0 && Float.compare(color.g, this.g) == 0 && Float.compare(color.b, this.b) == 0 && Float.compare(color.a, this.a) == 0;
    }

    @Nonnull
    public String getAsHexNoAlpha() {
        return Integer.toHexString(this.toIntNoAlpha());
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public void putIntoNBT(@Nonnull CompoundTag compoundNBT) {
        CompoundTag colorTag = new CompoundTag();
        colorTag.m_128350_("colorA", this.a);
        colorTag.m_128350_("colorR", this.r);
        colorTag.m_128350_("colorB", this.b);
        colorTag.m_128350_("colorG", this.g);
        compoundNBT.m_128365_(COLOR_TAG, (Tag)colorTag);
    }

    public int toInt() {
        int color = 0;
        color |= (int)(this.a * 255.0f) << 24;
        color |= (int)(this.r * 255.0f) << 16;
        color |= (int)(this.g * 255.0f) << 8;
        return color |= (int)(this.b * 255.0f);
    }

    public int toIntNoAlpha() {
        int color = 0;
        color |= (int)(this.r * 255.0f) << 16;
        color |= (int)(this.g * 255.0f) << 8;
        return color |= (int)(this.b * 255.0f);
    }

    @Nonnull
    public String toString() {
        return "Color{r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "}";
    }
}

